<?php
/*--------------------------------------------------------------
   Map.php 2021-06-02
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Data\Factory;

use Gambio\Admin\Modules\Statistics\Model\Collections\MapItems;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Map as MapData;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Map\Item as MapItem;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Map\Item\Title as MapItemTitle;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Map\Item\Value as MapItemValue;

class Map
{
    /**
     * Return map data.
     */
    public function createMapData(MapItems $mapItems): MapData
    {
        return MapData::create($mapItems);
    }
    
    
    /**
     * Return items.
     */
    public function createItems(MapItem ...$items): MapItems
    {
        return MapItems::create(...$items);
    }
    
    
    /**
     * Return item.
     */
    public function createItem(MapItemTitle $title, MapItemValue $value): MapItem
    {
        return MapItem::create($title, $value);
    }
    
    
    /**
     * Return item title.
     */
    public function createItemTitle(string $title): MapItemTitle
    {
        return MapItemTitle::create($title);
    }
    
    
    /**
     * Return item value.
     */
    public function createItemValue(float $value): MapItemValue
    {
        return MapItemValue::create($value);
    }
}